\name{ldknn}
\alias{ldknn}
\alias{ld1nn}
\alias{plot.ld1nn.run}
\alias{print.ld1nn.run}
\title{
Run the ldknn algorithm
}
\description{
The ldknn algorithm is used to detect bias in the composition of a lexical decison task, using k-nearest neighbor classification and the Levenshtein distance metric.
}
\usage{
ldknn(stimuli, types, reference, k = 1, multicore = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{stimuli}{
character strings corresponding to the stimuli in the experiment.}
  \item{types}{
factor corresponding to the type of each stimulus in the experiment.}
  \item{reference}{
a character string giving the reference level. Must be a level of the factor in \code{types}}
  \item{k}{
a value for the k parameter. Set to 1 by default.
}
  \item{multicore}{
with multicore=TRUE, ldknn will run on multiple cores simultaneously.
}
}
\details{
Combining k nearest neighbor classification with the Levenshtein distance produces an algorithm  which can be described as follows. 
For an experiment containing a number of stimuli, which can be words or nonwords:
\enumerate{
\item Compute the Levenshtein distances between the currently presented stimulus and all previously presented stimuli.  
\item Identify the previously presented stimuli that are at the k nearest distances from the current stimulus.
\item Compute the probability of a word response for the given stimulus based on the relative frequency of words among the nearest neighbors.
}
}
\value{
A list with class \code{ldknn.run}.
\item{data}{A data frame containing the results of the run. \code{stimulus} gives the stimulus values, \code{type} gives the types of the stimuli, \code{p} gives the probability for a \code{reference.level} response for that stimulus.}
\item{reference level}{The reference level used for the simulation.}
\item{Odds}{The odds, z value, and p value for a reference level response, resulting from a logistic regression in which the probabilities generated by the ldknn algorithm are used to predict stimulus types.}
\code{plot} and \code{print} methods are available for objects of class \code{ld1nn.run}
}
\references{
Keuleers, E., & Brysbaert, M. (manuscript submitted for publication). Detecting inherent bias in lexical decision experiments with the LD1NN algorithm.
}
\author{
Emmanuel Keuleers}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{levenshtein.distance}}
}
\examples{
data(english.words)
data(basque.words)
# set up a mock experiment: English stimuli are words, Basque stimuli are nonwords
experiment<-data.frame(stimulus=c(sample(english.words,500),
 sample(basque.words,500)),
 type=factor(rep(c('Word','Nonword'),each=500),levels=c('Word','Nonword')))
# randomize the trials
experiment<-experiment[sample(1:1000,1000),]
# run the ldknn algorithm
results<-ldknn(experiment$stimulus,experiment$type,'Word')
print(results)
plot(results)
}
