% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vtreat.R
\name{getNewVarNames}
\alias{getNewVarNames}
\title{Return a list of new treated variable names (coresponding to optional original variable names)}
\usage{
getNewVarNames(treatments, origVarNames = c())
}
\arguments{
\item{treatments}{the treatments slot from a treatmentplan object}

\item{origVarNames}{optional restrict to only derived variable originating from these original variables (null is no restriction)}
}
\value{
list of new treated variable names
}
\description{
Return a list of new treated variable names (coresponding to optional original variable names)
}
\examples{
dTrainN <- data.frame(x=c('a','a','a','a','b','b','b'),
    z=c(1,2,3,4,5,6,7),y=c(0,0,0,1,0,1,1))
dTestN <- data.frame(x=c('a','b','c',NA),
    z=c(10,20,30,NA))
treatmentsN = designTreatmentsN(dTrainN,colnames(dTrainN),'y')
}
\seealso{
\code{\link{designTreatmentsC}} \code{\link{designTreatmentsN}}
}

