% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{vsp_fa}
\alias{vsp_fa}
\title{Create a vintage sparse factor analysis object}
\usage{
vsp_fa(
  u,
  d,
  v,
  Z,
  B,
  Y,
  transformers,
  R_U,
  R_V,
  rownames = NULL,
  colnames = NULL
)
}
\arguments{
\item{u}{A \code{\link[=matrix]{matrix()}} of "left singular-ish" vectors.}

\item{d}{A \code{\link[=numeric]{numeric()}} vector of "singular-ish" values.}

\item{v}{A \code{\link[=matrix]{matrix()}} of "right singular-ish" vectors.}

\item{Z}{A \emph{matrix} of embeddings for each observation.}

\item{B}{A mixing \emph{matrix} describing how observation embeddings
and topics interact. Does not have to be diagonal!}

\item{Y}{A \emph{matrix} describing the compositions of various topics
or factors.}

\item{transformers}{A list of transformations from the \code{invertiforms}
package.}

\item{R_U}{Varimax rotation matrix use to transform \code{u} into \code{Z}.}

\item{R_V}{Varimax rotation matrix use to transform \code{v} into \code{Y}.}

\item{rownames}{Identifying names for each row of the original
data. Defaults to \code{NULL}, in which cases each row is given a
row number left-padded with zeros as a name.}

\item{colnames}{Identifying names for each column of the original
data. Defaults to \code{NULL}, in which cases each column is given a
row column left-padded with zeros as a name.}
}
\value{
A \code{svd_fa} object.
}
\description{
\code{vsp_fa} objects are a subclass of \code{\link[LRMF3:fa_like]{LRMF3::fa_like()}}, with additional
fields \code{u}, \code{d}, \code{v}, \code{transformers}, \code{R_U}, and \code{R_V}
}
