% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_rtweet.R
\name{ImportRtweet}
\alias{ImportRtweet}
\title{Import rtweet collected data}
\usage{
ImportRtweet(data)
}
\arguments{
\item{data}{Character string or dataframe. File path to or tibble of collected data from \pkg{rtweet}.}
}
\value{
A dataframe suitable for input into twitter network \code{\link{Create}} functions.
}
\description{
Imports \pkg{rtweet} collected data from \code{rda} or \code{rds} saved object file or from an rtweet
dataframe. Ensures \code{datasource} and specified \code{socialmedia} type are set so data is usable by
\code{\link{Create}} functions. Not required if collected data was collected by \code{vosonSML} and saved as an
\code{rds} file, use \code{\link{readRDS}} instead.
}
\note{
Only supports \pkg{rtweet} data collected using the \code{\link[rtweet]{search_tweets}} or
\code{\link[rtweet]{get_timeline}} functions.
}
\examples{
\dontrun{
# import rtweet collected data from dataframe
collect_tw <- ImportRtweet(rtweet_search_data)

# import rtweet collected data from file
collect_tw <- ImportRtweet("./rtweet_search_n100.rds")
}

}
