% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.activity.reddit.R
\name{Create.activity.reddit}
\alias{Create.activity.reddit}
\title{Create reddit activity network}
\usage{
\method{Create}{activity.reddit}(datasource, type, verbose = TRUE, ...)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"reddit"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"activity"}.}

\item{verbose}{Logical. Output additional information about the network creation. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a reddit activity network from subreddit thread comments. Nodes are comments and initial thread
posts, edges form the discussion structure and signify to which comment or post a comment has been made to.
}
\examples{
\dontrun{
# create a reddit activity network graph
activityNetwork <- redditData \%>\% Create("activity")

# network
# activityNetwork$nodes
# activityNetwork$edges
}

}
