% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcn_threads.R
\name{tcn_threads}
\alias{tcn_threads}
\title{Get threaded conversation tweets}
\usage{
tcn_threads(
  tweet_ids = NULL,
  token = NULL,
  end_point = "recent",
  skip_list = NULL
)
}
\arguments{
\item{tweet_ids}{List. Tweet ids of any tweet that are part of the threaded conversations of interest. Also accepts
a list of tweet URLs or a mixed list.}

\item{token}{List. Twitter API tokens.}

\item{end_point}{Character string. Twitter API v2 search end-point. Can be either "recent" for the last 7 days or
"all" if users app has access to historical tweets. Default is "recent".}

\item{skip_list}{Character vector. List of tweet conversation IDs to skip searching if found. This list is
automatically appended with conversation_id's when collecting multiple conversation threads to prevent search
duplication.}
}
\value{
A dataframe of tweets.
}
\description{
Collects tweets that share the same Twitter conversation ID as supplied tweets.
}
\examples{
\dontrun{
# get twitter conversation threads by tweet ids or urls
tweet_ids <- c("xxxxxxxx",
               "https://twitter.com/xxxxxxxx/status/xxxxxxxx")
tweets <- tcn_threads(tweet_ids, token)
}

}
