% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{pointMap}
\alias{pointMap}
\title{Point mapping}
\usage{
pointMap(
  occs,
  spName,
  land = NA,
  ptCol = "#bd0026",
  landCol = "gray",
  waterCol = "steelblue",
  ptSize = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{occs}{A \code{data.frame} with at least two columns
named "longitude" and "latitude" or that
can be coerced into this format.}

\item{spName}{A character string with the species
name to be used in the plot title.}

\item{land}{An optional coastline polygon shapefile
of type \code{sf} to provide geographic context for the
occurrence points.}

\item{ptCol}{Color for occurrence points on map}

\item{landCol}{Color for land on map}

\item{waterCol}{Color for water on map}

\item{ptSize}{\code{numeric} value for \code{cex};
size of occurrence points on map.}

\item{verbose}{\code{logical}. Switching to \code{FALSE} mutes message describing
which columns in \code{occs} are interpreted as x and y coordinates.}

\item{...}{Additional optional arguments to pass to
\code{ggplot} initial plot object.}
}
\value{
A \code{ggplot} plot object.
}
\description{
A convenient wrapper around ggplot
to generate formatted occurrence point plots.
}
\examples{
occs <- read.csv(system.file("extdata/Steindachneria_argentea.csv",
                             package='voluModel'))
spName <- "Steindachneria argentea"
pointMap(occs = occs, spName = spName,
         land = rnaturalearth::ne_countries(scale = "small",
                                            returnclass = "sf")[1])

}
\seealso{
\code{\link[ggplot2:ggplot]{ggplot}}
}
\keyword{plotting}
