% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_optimum.R
\name{unique_optimum}
\alias{unique_optimum}
\title{Check new optimum for uniqueness.}
\usage{
unique_optimum(L, argument, tolerance)
}
\arguments{
\item{L}{A list of identified optima which contains lists with
\itemize{
\item \code{value} and
\item \code{argument}
}
of each identified optimum.}

\item{argument}{The argument of a candidate optimum.}

\item{tolerance}{A non-negative numeric value. For an identified optimum and a candidate
optimum, if all coordinate differences are smaller than \code{tolerance},
they are considered as equal.}
}
\value{
A boolean. If \code{TRUE}, \code{argument} is not contained in \code{L}.
If \code{FALSE}, \code{argument} is already contained in \code{L}.
}
\description{
This function checks if a new optimum \code{argument} is not yet contained
in \code{L}.
}
