% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.fbl_vtl_ts}
\alias{autoplot.fbl_vtl_ts}
\title{Plot forecasts from a vital model}
\usage{
\method{autoplot}{fbl_vtl_ts}(object, ...)
}
\arguments{
\item{object}{A fable object obtained from a vital model.}

\item{...}{Further arguments ignored.}
}
\value{
A ggplot2 object.
}
\description{
Produces a plot showing forecasts obtained from a model applied to a vital object.
}
\examples{
library(ggplot2)
norway_mortality |>
  model(ave = FMEAN(Mortality)) |>
  forecast(h = 10) |>
  autoplot() + scale_y_log10()

}
\author{
Rob J Hyndman
}
