% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model.vital}
\alias{model.vital}
\title{Estimate models for vital data}
\usage{
\method{model}{vital}(.data, ..., .safely = TRUE)
}
\arguments{
\item{.data}{A vital object including an age variable.}

\item{...}{Definitions for the models to be used. All models must share the
same response variable.}

\item{.safely}{If a model encounters an error, rather than aborting the process
a \link[fabletools:null_model]{NULL model} will be returned instead. This allows for an error
to occur when computing many models, without losing the results of the successful models.}
}
\value{
A mable containing the fitted models.
}
\description{
Trains specified model definition(s) on a dataset. This function will
estimate the a set of model definitions (passed via \code{...}) to each series
within \code{.data} (as identified by the key structure). The result will be a
mable (a model table), which neatly stores the estimated models in a tabular
structure. Rows of the data identify different series within the data, and
each model column contains all models from that model definition. Each cell
in the mable identifies a single model.
}
\section{Parallel}{


It is possible to estimate models in parallel using the
\href{https://cran.r-project.org/package=future}{future} package. By specifying a
\code{\link[future:plan]{future::plan()}} before estimating the models, they will be computed
according to that plan.
}

\section{Progress}{


Progress on model estimation can be obtained by wrapping the code with
\code{progressr::with_progress()}. Further customisation on how progress is
reported can be controlled using the \code{progressr} package.
}

\examples{
aus_mortality |>
  dplyr::filter(State == "Victoria", Sex == "female") |>
  model(
    naive = FNAIVE(Mortality),
    mean = FMEAN(Mortality)
  )
}
\author{
Rob J Hyndman and Mitchell O'Hara-Wild
}
