% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life_expectancy.R
\name{life_expectancy}
\alias{life_expectancy}
\title{Compute life expectancy from age-specific mortality rates}
\usage{
life_expectancy(.data, from_age = 0, mortality)
}
\arguments{
\item{.data}{A vital object including an age variable and a variable containing mortality rates.}

\item{from_age}{Age at which life expectancy to be calculated. Either a scalar or a vector of ages.}

\item{mortality}{Variable in \code{.data} containing Mortality rates (mx). If omitted, the variable with name  \code{mx}, \code{Mortality} or \code{Rate} will be used (not case sensitive).}
}
\value{
A \code{vital} object with life expectancy in column \code{ex}.
}
\description{
Returns remaining life expectancy at a given age (0 by default).
}
\examples{
# Compute Victorian life expectancy for females over time
aus_mortality |>
  dplyr::filter(Code == "VIC", Sex == "female") |>
  life_expectancy()
}
\references{
Chiang CL. (1984) \emph{The life table and its applications}.
Robert E Krieger Publishing Company: Malabar.

Keyfitz, N, and Caswell, H. (2005) \emph{Applied Mathematical Demography},
Springer-Verlag: New York.

Preston, S.H., Heuveline, P., and Guillot, M. (2001)
\emph{Demography: measuring and modeling population processes}. Blackwell
}
\seealso{
\code{\link[=life_table]{life_table()}}
}
\author{
Rob J Hyndman
}
