% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_clustering.R
\name{optimal_score}
\alias{optimal_score}
\title{Find minimum or maximum score in a vector}
\usage{
optimal_score(x, method = c("firstmax", "globalmax", "firstmin", "globalmin"))
}
\arguments{
\item{x}{a numeric vector}

\item{method}{one of "firstmax", "globalmax", "firstmin" or "globalmin"}
}
\value{
the index (not k) of the identified maximum or minimum score
}
\description{
This function is meant to be used with compute_metric. For Gap statistic,
use \code{\link[cluster:clusGap]{cluster::maxSE()}}.
}
\examples{
data_to_cluster <- iris[c("Petal.Length", "Sepal.Length")]
dmat <- compute_dmat(data_to_cluster, "euclidean", TRUE)
clusters <- compute_clusters(dmat, "complete")
res <- compute_metric(scale(data_to_cluster), clusters, "Dunn")
optimal_score(res$score, method = "firstmax")
}
