% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSettings.R
\name{addSettings}
\alias{addSettings}
\title{Add settings columns to a \verb{<summarised_result>} object}
\usage{
addSettings(
  result,
  settingsColumns = colnames(settings(result)),
  columns = lifecycle::deprecated()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{settingsColumns}{Settings to be added as columns, by default all
settings will be added. If NULL or empty character vector, no settings will
be added.}

\item{columns}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A \verb{<summarised_result>} object with the added setting columns.
}
\description{
Add settings columns to a \verb{<summarised_result>} object
}
\examples{
library(visOmopResults)
mockSummarisedResult() |>
  addSettings(settingsColumns = c("result_type"))

}
