% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatTable.R
\name{formatTable}
\alias{formatTable}
\title{Creates a tibble with specific rows pivotted into columns}
\usage{
formatTable(
  result,
  header,
  delim = "\\n",
  includeHeaderName = TRUE,
  includeHeaderKey = TRUE
)
}
\arguments{
\item{result}{A summarised_result.}

\item{header}{Names of the columns to make headers. Names not corresponding
to a column of the table result, will be used as headers at the defined
position.}

\item{delim}{Delimiter to use to separate headers.}

\item{includeHeaderName}{Whether to include the column name as header.}

\item{includeHeaderKey}{Whether to include the header key (header,
header_name, header_level) before each header type in the column names.}
}
\value{
A tibble with rows pivotted into columns with column names for future
spanner headers.
}
\description{
Pivots a summarised_result object based on the column names in header. The
names of the new columns refer to the information on the column based on
the header input, with labels are separated using a delimiter.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
result <- mockSummarisedResult()

result |>
  formatTable(
    header = c(
      "Study cohorts", "group_level", "Study strata", "strata_name",
      "strata_level"
    ),
    includeHeaderName = FALSE
  )
}
