% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visConfigure.R
\name{visConfigure}
\alias{visConfigure}
\title{Network visualization configure options}
\usage{
visConfigure(graph, enabled = NULL, filter = NULL, container = NULL,
  showButton = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{enabled}{: Boolean. Default to true. Toggle the configuration interface on or off. This is an optional parameter. If left undefined and any of the other properties of this object are defined, this will be set to true.}

\item{filter}{: String, Array, Boolean, Function. Default to true. When a boolean, true gives you all options, false will not show any. If a string is supplied, any combination of the following is allowed: nodes, edges, layout, interaction, manipulation, physics, selection, renderer. Feel free to come up with a fun seperating character. Finally, when supplied an array of strings, any of the previously mentioned fields are accepted.}

\item{container}{: DOM element. This allows you to put the configure list in another HTML container than below the network.}

\item{showButton}{: Boolean. Default to true. Show the generate options button at the bottom of the configurator.}
}
\description{
Network visualization configure options. For full documentation, have a look at \link{visDocumentation}.
}
\examples{

\dontrun{

nodes <- data.frame(id = 1:3, title = paste0("<p>", 1:3,"<br> tooltip</p>"))
edges <- data.frame(from = c(1,2), to = c(1,3))

visNetwork(nodes, edges) \%>\%
 visConfigure(enabled = TRUE, filter = "interaction")
 
# using visNetworkEditor
custom_network <- visNetworkEditor(object = network)
custom_network

custom_network <- visNetworkEditor(object = network, filter = "nodes,edges")
custom_network
}

}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visConfigure}, \link{visTree}, \link{visNetworkEditor}
}
