% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/formatFunctions.R
\name{formatFunctions}
\alias{formatFunctions}
\title{Format and visualise functions used to generate virtual species with \code{\link{generateSpFromFun}}}
\usage{
formatFunctions(x = NULL, rescale = TRUE, ...)
}
\arguments{
\item{x}{NULL or a \code{RasterStack}. If you want to visualise the functions,
provide your \code{RasterStack} here.}

\item{rescale}{\code{TRUE} or \code{FALSE}. If \code{TRUE}, individual response
plots are rescaled between 0 and 1 with the formula (val - min) / (max - min).}

\item{...}{the parameters to be formatted. See details.}
}
\description{
This function is a helper function to simplify the formatting of functions
for generateSpFromFun.
}
\details{
This function formats the \code{parameters} argument of \code{\link{generateSpFromFun}}.
For each environmental variable, provide a vector containing the function name, and its arguments.


For example, assume we want to generate a species responding to two environmental variables bio1 and bio2.
\itemize{
\item{The response to bio1 is a normal response (\code{\link{dnorm}}), of mean 1 and standard deviation 0.5.}
\item{The response to bio2 is a linear response (\code{\link{linearFun}}), of slope (a) 2 and intercept (b) 5.}
}
The correct writing is:

\code{formatFunctions(
bio1 = c(fun = "dnorm", mean = 1, sd = 0.5),
bio2 = c(fun = "linearFun", a = 2, b = 5))}
}
\section{Warning}{

Do not use 'x' as a name for your environmental variables.
}
\examples{
my.parameters <- formatFunctions(variable1 = c(fun = 'dnorm',
                                            mean = 0.00012, sd = 0.0001),
                              variable2 = c(fun = 'linearFun', a = 1, b = 0))


my.parameters <- formatFunctions(bio1 = c(fun = "logisticFun",
                                         alpha = -12.7, beta = 68),
                                 bio2 = c(fun = "linearFun",
                                          a = -0.03, b = 191.2),
                                 bio3 = c(fun = "dnorm",
                                          mean = 86.4, sd = 19.1),
                                 bio4 = c(fun = "logisticFun",
                                          alpha = 2198.5, beta = 11381.4))
\dontrun{
# An example using worldclim data
bio1.4 <- getData('worldclim', var='bio', res=10)[[1:4]]
my.parameters <- formatFunctions(x = bio1.4,
                                 bio1 = c(fun = "logisticFun",
                                          alpha = -12.7, beta = 68),
                                 bio2 = c(fun = "linearFun",
                                          a = -0.03, b = 191.2),
                                 bio3 = c(fun = "dnorm",
                                          mean = 86.4, sd = 19.1),
                                 bio4 = c(fun = "logisticFun",
                                          alpha = 2198.5, beta = 11381.4))
}
}
\author{
Boris Leroy \email{leroy.boris@gmail.com}

with help from C. N. Meynard, C. Bellard & F. Courchamp
}

