% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viridis.R
\name{viridis}
\alias{inferno}
\alias{magma}
\alias{plasma}
\alias{viridis}
\alias{viridisMap}
\title{Matplotlib 'viridis' color map}
\usage{
viridis(n, alpha = 1, option = "D")

viridisMap(n = 256, alpha = 1, option = "D")

magma(n, alpha = 1)

inferno(n, alpha = 1)

plasma(n, alpha = 1)
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{option}{A character string indicating the colormap option to use. Four
options are available: "magma" (or "A"), "inferno" (or "B"), "plasma" (or "C"),
and "viridis" (or "D", the default option).}
}
\value{
\code{viridis} returns a character vector, \code{cv}, of color hex
codes. This can be used either to create a user-defined color palette for
subsequent graphics by \code{palette(cv)}, a \code{col =} specification in
graphics functions or in \code{par}.

\code{viridisMap} returns a \code{n} lines data frame containing the
red (\code{R}), green (\code{G}), blue (\code{B}) and alpha (\code{alpha})
channels of \code{n} equally spaced colors along the 'viridis' color map.
\code{n = 256} by default, which corresponds to the data from the original
'viridis' color map in Matplotlib.
}
\description{
This function creates a vector of \code{n} equally spaced colors along the
Matplolib 'viridis' color map created by \href{https://github.com/stefanv}{Stefan van der Walt}
and \href{https://github.com/njsmith}{Nathaniel Smith}. This color map is
designed in such a way that it will analytically be perfectly perceptually-uniform,
both in regular form and also when converted to black-and-white. It is also
designed to be perceived by readers with the most common form of color blindness.
}
\details{
\code{magma()}, \code{plasma()}, and \code{inferno()} are convenience
functions for the other colormap options, which are useful the scale must
be passed as a function name.

Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
devices: see \code{\link[grDevices]{rgb}}.
}
\examples{
library(ggplot2)
library(hexbin)

dat <- data.frame(x = rnorm(10000), y = rnorm(10000))

ggplot(dat, aes(x = x, y = y)) +
  geom_hex() + coord_fixed() +
  scale_fill_gradientn(colours = viridis(256, option = "D"))

# using code from RColorBrewer to demo the palette
n = 200
image(
  1:n, 1, as.matrix(1:n),
  col = viridis(n, option = "D"),
  xlab = "viridis n", ylab = "", xaxt = "n", yaxt = "n", bty = "n"
)

}
\author{
Simon Garnier: \email{garnier@njit.edu}, \href{https://twitter.com/sjmgarnier}{@sjmgarnier}
}

