% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{mp_}
\alias{mp_}
\alias{thg_}
\title{Sample of WHODrug}
\format{
\code{mp_} is a data.table with 8 variables and 14146 rows.
\itemize{
\item \code{MedicinalProd_Id} Integer. The medicinalproduct identifier.
\item \code{Sequence.number.1} and \code{2} Characters. Complement to DrecNo.
\item \code{DrecNo} Character. Drug Record Number, pivotal to identify drugs
with \code{\link[=get_drecno]{get_drecno()}}.
\item \code{drug_name_t} Character. The name of the drug. Compared to the
original \code{drug_name} variable in \code{mp} table,
this variable is trimmed for white spaces, and names
are in lowercase.
\item \code{Create.date} Character. The date the record was created.
\item \code{Date.changed} Character. The date the record was last changed.
\item \code{Country} Character. The country where the record was created.
}
\code{thg_} is a data.table with 5 variables and 4079 rows.
\itemize{
\item \code{Therapgroup_Id} Integer. The identifier of the therapeutic group.
\item \code{ATC.code} Character. The ATC code of the drug.
\item \code{Create.date} Character. The date the record was created.
\item \code{Official.ATC.code} Character. Whether the ATC code
is official (Yes/No).
\item \code{MedicinalProd_Id} Integer. The medicinalproduct identifier.
}

An object of class \code{data.table} (inherits from \code{data.frame}) with 4079 rows and 5 columns.
}
\source{
None
}
\usage{
data(mp_)

thg_
}
\description{
A small part of WHODrug, used to illustrate the package examples and vignettes.
You can find DrecNo related to immune checkpoint inhibitors, paracetamol,
tramadol, tretinoin, anti-thrombin iii, and ATC classes
L03AA Colony stimulating factors, C09AA ACE inhibitors, plain,
J01CA Penicillins with extended spectrum.
Compounds are \code{thg_} and \code{mp_}.
See examples in \code{\link{get_drecno}} and \code{\link{get_atc_code}}
}
\examples{
data(mp_)
}
\references{
There is none
}
\keyword{datasets}
\keyword{whodrug}
