% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_helpers.R
\name{import_data_from_polymapR}
\alias{import_data_from_polymapR}
\alias{filter_non_conforming_classes}
\alias{ph_matrix_to_list}
\alias{is.prob.data}
\alias{mf_h}
\alias{mrk_chisq_test}
\alias{dist_prob_to_class}
\alias{segreg_poly}
\alias{import_phased_maplist_from_polymapR}
\alias{prepare_map}
\alias{imf_h}
\alias{get_LOD}
\alias{ph_list_to_matrix}
\title{Import data from polymapR}
\usage{
import_data_from_polymapR(
  input.data,
  ploidy,
  parent1 = "P1",
  parent2 = "P2",
  input.type = c("discrete", "probabilistic"),
  prob.thres = 0.95,
  pardose = NULL,
  offspring = NULL,
  filter.non.conforming = TRUE,
  verbose = TRUE
)

filter_non_conforming_classes(input.data, prob.thres = NULL)

ph_matrix_to_list(M)

is.prob.data(x)

mf_h(d)

mrk_chisq_test(x, ploidy)

dist_prob_to_class(geno, prob.thres = 0.9)

segreg_poly(ploidy, d.p1, d.p2)

import_phased_maplist_from_polymapR(maplist, mappoly.data, ploidy = NULL)

prepare_map(input.map, config = "best")

imf_h(r)

get_LOD(x, sorted = TRUE)

ph_list_to_matrix(L, ploidy)
}
\arguments{
\item{input.data}{a \code{polymapR} dataset}

\item{ploidy}{ploidy level}

\item{parent1}{a character string containing the name (or pattern of genotype IDs) of parent 1}

\item{parent2}{a character string containing the name (or pattern of genotype IDs) of parent 2}

\item{input.type}{Indicates whether the input is discrete ("disc") or probabilistic ("prob")}

\item{prob.thres}{probability threshold to select the genotype. 
Values below this genotype are assumed as missing data}

\item{pardose}{matrix of dimensions (n.mrk x 3) containing the name of the markers in the first column, and the 
dosage of parents 1 and 2 in columns 2 and 3. (see polymapR vignette)}

\item{offspring}{a character string containing the name (or pattern of genotype IDs) of the offspring 
individuals. If \code{NULL} (default) it considers all individuals as offsprings, except 
\code{parent1} and \code{parent2}.}

\item{filter.non.conforming}{if \code{TRUE} exclude samples with non 
expected genotypes under no double reduction. Since markers were already filtered in polymapR, the default is 
\code{FALSE}.}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}

\item{M}{matrix whose columns represent homologous chromosomes and
the rows represent markers}

\item{x}{an object of class \code{mappoly.map}}

\item{geno}{the probabilistic genotypes contained in the object
\code{'mappoly.data'}}

\item{d.p1}{the dosage in parent P}

\item{d.p2}{the dosage in parent Q}

\item{maplist}{a list of phased maps obtained using function 
\code{create_phased_maplist} from package \code{polymapR}}

\item{mappoly.data}{a dataset used to obtain \code{maplist}, 
converted into class \code{mappoly.data}}

\item{sorted}{logical. if \code{TRUE}, the LOD Scores are displayed
in a decreasing order}

\item{L}{a list of configuration phases}

\item{void}{internal function to be documented}
}
\value{
a list of linkage phase configurations

a matrix containing the doses of each genotype and
    marker. Markers are disposed in rows and individuals are 
    disposed in columns. Missing data are represented by NAs

a vector containing the expected segregation frequency for
    all possible genotypic classes.

a numeric vector containing the LOD Scores

a matrix whose columns represent homologous chromosomes and
    the rows represent markers
}
\description{
Function to import datasets from polymapR. Function from MAPpoly.

This function converts linkage phase configurations from matrix
form to list

Computes the polysomic segregation frequency given a ploidy level
and the dosage of the locus in both parents. It does not consider
double reduction.

Function to import phased map lists from polymapR. Function from MAPpoly.

This function converts linkage phase configurations from list
to matrix form
}
\details{
See examples at \url{https://rpubs.com/mmollin/tetra_mappoly_vignette}.

See examples at \url{https://rpubs.com/mmollin/tetra_mappoly_vignette}.
}
\references{
Bourke PM et al: (2019) PolymapR — linkage analysis and genetic map 
    construction from F1 populations of outcrossing polyploids. 
    _Bioinformatics_ 34:3496–3502.
    \doi{10.1093/bioinformatics/bty1002}

    Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}

Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
    
    Serang O, Mollinari M, Garcia AAF (2012) Efficient Exact 
    Maximum a Posteriori Computation for Bayesian SNP 
    Genotyping in Polyploids. _PLoS ONE_ 7(2): 
    e30906.

Bourke PM et al: (2019) PolymapR — linkage analysis and genetic map 
    construction from F1 populations of outcrossing polyploids. 
    _Bioinformatics_ 34:3496–3502.
    \doi{10.1093/bioinformatics/bty1002}

    Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari \email{mmollin@ncsu.edu}

Marcelo Mollinari, \email{mmollin@ncsu.edu}

Marcelo Mollinari \email{mmollin@ncsu.edu}
}
\keyword{internal}
