% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_grid.R
\name{emis_grid}
\alias{emis_grid}
\title{Allocate emissions into a grid returning point emissions or flux}
\usage{
emis_grid(spobj = net, g, sr, type = "lines", FN = "sum", flux = TRUE, k = 1)
}
\arguments{
\item{spobj}{A spatial dataframe of class "sp" or "sf". When class is "sp"
it is transformed to "sf".}

\item{g}{A grid with class "SpatialPolygonsDataFrame" or "sf".}

\item{sr}{Spatial reference e.g: 31983. It is required if spobj and g are
not projected. Please, see http://spatialreference.org/.}

\item{type}{type of geometry: "lines", "points" or "polygons".}

\item{FN}{Character indicating the function. Default is "sum"}

\item{flux}{Logical, if TRUE, it return flux (mass / area / time (implicit))
in a polygon grid, if false,  mass / time (implicit) as points, in a similar fashion
as EDGAR provide data.}

\item{k}{Numeric to multiply emissions}
}
\description{
\code{\link{emis_grid}} allocates emissions proportionally to each grid
 cell. The process is performed by the intersection between geometries and the grid.
It means that requires "sr" according to your location for the projection.
It is assumed that spobj is a Spatial*DataFrame or an "sf" with the pollutants
in data. This function returns an object of class "sf".

It is
}
\note{
\strong{1) If flux = TRUE (default), emissions are flux = mass / area / time (implicit), as polygons.}
\strong{If flux = FALSE, emissions are mass / time (implicit), as points.}
\strong{Time untis are not displayed because each use can have different time units}
\strong{for instance, year, month, hour second, etc.}

\strong{2) Therefore, it is good practice to have time units in 'spobj'. }
\strong{This implies that spobj MUST include units!. }

\strong{3) In order to check the sum of the emissions, you must calculate the grid-area}
\strong{in km^2 and multiply by each column of the resulting emissions grid, and then sum.}


\strong{4) If FN = "sum", is mass conservative!. }
}
\examples{
\dontrun{
data(net)
g <- make_grid(net, 1/102.47/2) #500m in degrees
names(net)
netsf <- sf::st_as_sf(net)
netg <- emis_grid(spobj = netsf[, c("ldv", "hdv")], g = g, sr= 31983)
plot(netg["ldv"], axes = TRUE)
plot(netg["hdv"], axes = TRUE)
netg <- emis_grid(spobj = netsf[, c("ldv", "hdv")], g = g, sr= 31983, FN = "mean")
plot(netg["ldv"], axes = TRUE)
plot(netg["hdv"], axes = TRUE)
netg <- emis_grid(spobj = netsf[, c("ldv", "hdv")], g = g, sr= 31983, flux = FALSE)
plot(netg["ldv"], axes = TRUE, pch = 16,
pal = cptcity::cpt(colorRampPalette= TRUE, rev = TRUE), cex = 3)
}
}
