% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-bare.R, R/type2.R
\name{vec_ptype2.logical}
\alias{vec_ptype2.logical}
\alias{vec_ptype2.integer}
\alias{vec_ptype2.double}
\alias{vec_ptype2.complex}
\alias{vec_ptype2.character}
\alias{vec_ptype2.raw}
\alias{vec_ptype2.list}
\alias{vec_ptype2}
\alias{vec_default_ptype2}
\title{Find the common type for a pair of vector types}
\usage{
\method{vec_ptype2}{logical}(x, y, ..., x_arg = "x", y_arg = "y")

\method{vec_ptype2}{integer}(x, y, ..., x_arg = "x", y_arg = "y")

\method{vec_ptype2}{double}(x, y, ..., x_arg = "x", y_arg = "y")

\method{vec_ptype2}{complex}(x, y, ..., x_arg = "x", y_arg = "y")

\method{vec_ptype2}{character}(x, y, ..., x_arg = "x", y_arg = "y")

\method{vec_ptype2}{raw}(x, y, ..., x_arg = "x", y_arg = "y")

\method{vec_ptype2}{list}(x, y, ..., x_arg = "x", y_arg = "y")

vec_ptype2(x, y, ..., x_arg = "x", y_arg = "y")

vec_default_ptype2(x, y, ..., x_arg = "x", y_arg = "y")
}
\arguments{
\item{x, y}{Vector types.}

\item{...}{These dots are for future extensions and must be empty.}

\item{x_arg, y_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}
}
\description{
\code{vec_ptype2()} finds the common type for a pair of vectors, or dies trying.
It forms the foundation of the vctrs type system, along with \code{\link[=vec_cast]{vec_cast()}}.
This powers type coercion but should not usually be called directly;
instead call \code{\link[=vec_ptype_common]{vec_ptype_common()}}.
}
\section{Coercion rules}{

vctrs thinks of the vector types as forming a partially ordered set, or
poset. Then finding the common type from a set of types is a matter of
finding the least-upper-bound; if the least-upper-bound does not exist,
there is no common type. This is the case for many pairs of 1d vectors.

The poset of the most important base vectors is shown below:
(where datetime stands for \code{POSIXt}, and date for \code{Date})

\figure{coerce.png}
}

\section{S3 dispatch}{

\code{vec_ptype2()} dispatches on both arguments. This is implemented by having
methods of \code{vec_ptype2()}, e.g. \code{vec_ptype2.integer()} also be S3 generics,
which call e.g. \code{vec_ptype2.integer.double()}. \code{vec_ptype2.x.y()} must
return the same value as \code{vec_ptype2.y.x()}; this is currently not enforced,
but should be tested.

Whenever you implement a \code{vec_ptype2.new_class()} generic/method,
make sure to always provide \code{vec_ptype2.new_class.default()}. It
should normally call \code{vec_default_ptype2()}.

See \code{vignette("s3-vector")} for full details.
}

\keyword{internal}
