% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-list-of.R
\name{list_of}
\alias{list_of}
\alias{as_list_of}
\alias{validate_list_of}
\alias{is_list_of}
\alias{vec_ptype2.vctrs_list_of}
\alias{vec_cast.vctrs_list_of}
\title{\code{list_of} S3 class for homogenous lists}
\usage{
list_of(..., .ptype = NULL)

as_list_of(x, ...)

validate_list_of(x)

is_list_of(x)

\method{vec_ptype2}{vctrs_list_of}(x, y, ..., x_arg = "x", y_arg = "y")

\method{vec_cast}{vctrs_list_of}(x, to, ...)
}
\arguments{
\item{...}{Vectors to coerce.}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}

\item{x}{For \code{as_list_of()}, a vector to be coerced to list_of.}

\item{y, to}{Arguments to \code{vec_ptype2()} and \code{vec_cast()}.}

\item{x_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{y_arg}{Argument names for \code{x} and \code{y}. These are used
in error messages to inform the user about the locations of
incompatible types (see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}
}
\description{
A \code{list_of} object is a list where each element has the same type.
Modifying the list with \code{$}, \code{[}, and \code{[[} preserves the constraint
by coercing all input items.
}
\details{
Unlike regular lists, setting a list element to \code{NULL} using \code{[[}
does not remove it.
}
\examples{
x <- list_of(1:3, 5:6, 10:15)
if (requireNamespace("tibble", quietly = TRUE)) {
  tibble::tibble(x = x)
}

vec_c(list_of(1, 2), list_of(FALSE, TRUE))
}
