% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_api_client.R
\name{vault_api_client}
\alias{vault_api_client}
\title{Vault Low-Level Client}
\description{
Low-level API client.  This can be used to directly communicate
with the vault server.  This object will primarily be useful for
debugging, testing or developing new vault methods, but is
nonetheless described here.
}
\section{Methods}{


\describe{
\item{\code{is_authenticated}}{
  Test if the vault client currently holds a vault token.  This method does not verify the token - only test that is present.
  \cr\emph{Usage:}\preformatted{is_authenticated()}
}
\item{\code{set_token}}{
  Set a token within the client
  \cr\emph{Usage:}\preformatted{set_token(token, verify = FALSE, quiet = FALSE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{token}:   String, with the new vault client token
    }

    \item{\code{verify}:   Logical, indicating if we should test that the token is valid. If \code{TRUE}, then we use \code{$verify_token()} to test the token before setting it and if it is not valid an error will be thrown and the token not set.
    }

    \item{\code{quiet}:   Logical, if \code{TRUE}, then informational messages will be suppressed.
    }
  }
}
\item{\code{verify_token}}{
  Test that a token is valid with the vault.  This will call vault's \code{/sys/capabilities-self} endpoint with the token provided and check the \code{/sys} path.
  \cr\emph{Usage:}\preformatted{verify_token(token, quiet = TRUE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{token}:   String, with the vault client token to test
    }

    \item{\code{quiet}:   Logical, if \code{TRUE}, then informational messages will be suppressed.
    }
  }
}
\item{\code{server_version}}{
  Retrieve the vault server version.  This is by default cached within the client for a session.  Will return an R \code{numeric_version} object.
  \cr\emph{Usage:}\preformatted{server_version(refresh = FALSE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{refresh}:   Logical, indicating if the server version information should be refreshed even if known.
    }
  }
}
\item{\code{GET}}{
  Send a \code{GET} request to the vault server
  \cr\emph{Usage:}\preformatted{GET(path, ...)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   The server path to use.  This is the "interesting" part of the path only, with the server base url and api version information added.
    }

    \item{\code{...}:   Additional \code{httr}-compatible options.  These will be named parameters or \code{httr} "request" objects.
    }
  }
}
\item{\code{LIST}}{
  Send a \code{LIST} request to the vault server
  \cr\emph{Usage:}\preformatted{LIST(path, ...)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   The server path to use.  This is the "interesting" part of the path only, with the server base url and api version information added.
    }

    \item{\code{...}:   Additional \code{httr}-compatible options.  These will be named parameters or \code{httr} "request" objects.
    }
  }
}
\item{\code{POST}}{
  Send a \code{POST} request to the vault server
  \cr\emph{Usage:}\preformatted{POST(path, ...)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   The server path to use.  This is the "interesting" part of the path only, with the server base url and api version information added.
    }

    \item{\code{...}:   Additional \code{httr}-compatible options.  These will be named parameters or \code{httr} "request" objects.
    }
  }
}
\item{\code{PUT}}{
  Send a \code{PUT} request to the vault server
  \cr\emph{Usage:}\preformatted{PUT(path, ...)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   The server path to use.  This is the "interesting" part of the path only, with the server base url and api version information added.
    }

    \item{\code{...}:   Additional \code{httr}-compatible options.  These will be named parameters or \code{httr} "request" objects.
    }
  }
}
\item{\code{DELETE}}{
  Send a \code{DELETE} request to the vault server
  \cr\emph{Usage:}\preformatted{DELETE(path, ...)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   The server path to use.  This is the "interesting" part of the path only, with the server base url and api version information added.
    }

    \item{\code{...}:   Additional \code{httr}-compatible options.  These will be named parameters or \code{httr} "request" objects.
    }
  }
}
}
}

\examples{

server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  # Ordinarily, we would use the "vault_client" object for
  # high-level access to the vault server
  client <- server$client()
  client$status()

  # The api() method returns the "api client" object:
  api <- client$api()
  api

  # This allows running arbitrary HTTP requests against the server:
  api$GET("/sys/seal-status")

  # this is how vaultr is internally implemented so anything can
  # be done here, for example following vault's API documentation
  # https://www.vaultproject.io/api/secret/kv/kv-v1.html#sample-request-2
  api$POST("/secret/mysecret", body = list(key = "value"))
  api$GET("/secret/mysecret")
  api$DELETE("/secret/mysecret")

  # cleanup
  server$kill()
}
}
