% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HydrophilicityEvaluation.R
\name{getProtAtomsNearWater}
\alias{getProtAtomsNearWater}
\title{Number of Solvent Accessible/Exposed Protein Atoms Near a Water}
\usage{
getProtAtomsNearWater(h2o.oi, h2o.idc, atoms.oi, h2o.prot.dists,
  h2o.prot.dists.tf)
}
\arguments{
\item{h2o.oi}{The index of the water of interest}

\item{h2o.idc}{The indices of the waters within the protein structure}

\item{atoms.oi}{The protein \code{data.frame} with the \code{SASA} and \code{SASA lost}
values for each atom within the protein.}

\item{h2o.prot.dists}{Distance \code{matrix} for all water-protein through space
distances}

\item{h2o.prot.dists.tf}{The \code{TRUE}/\code{FALSE} matrix indicating if the protein-
water distances are less than or equal to the user defined cutoff value
denoted by the \code{h2o.prot.dist.max} parameter for
\code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}}. From \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}}: the
maximum distance between the water oxygen atoms and the protein for
consideration in the determination for hydrophilicity values; default: 6.0}
}
\value{
This function returns a \code{data.frame} with:
\itemize{
\item \strong{nearby.prot.atoms}: protein atoms within the user specified distance
of a water's oxygen atom
\item \strong{distances}: The distance -- in Angstroms -- from the water to the
closest solvent accessible protein atom so long as the distance is
equal to or less than the user provided value; see \code{h2o.prot.dists.tf}
above
\item \strong{dist.is.min}: ; see \code{h2o.prot.dists.tf}
above
\item \strong{SASA.and.minDist}: \code{TRUE}/\code{FALSE} indicating if the protein atom is
\emph{\strong{BOTH}} solvent accessible and at least the user defined number
of Angstroms from a water's oxygen atom; see \code{h2o.prot.dists.tf}
above
\item \strong{h2o.atom.ids}: Unique water atom ID
\item \strong{h2o.x}: Atom coordinate \code{X} for the water's oxygen atom
\item \strong{h2o.y}: Atom coordinate \code{Y} for the water's oxygen atom
\item \strong{h2o.z}: Atom coordinate \code{Z} for the water's oxygen atom
}

These values are returned in \code{df.nearby.prot.atoms} of the results of
\code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}}
}
\description{
Calculate the number of solvent exposed protein atoms near a
water.
}
\details{
This function is called within \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}} to
determine protein atoms near each water oxygen.

This function is designed to work with the \code{\link[base:lapply]{base::lapply()}} function and
thus each \code{h2o.oi} is independently evaluated
}
\examples{
  \dontrun{
  getProtAtomsNearWater(h2o.oi = PDB.1hai.h2o.oi,
                        h2o.idc = PDB.1hai.clean.h2o.idc,
                        atoms.oi = PDB.1hai.aoi.clean.SASA,
                        h2o.prot.dists = PDB.1hai.h2o.prot.dists,
                        h2o.prot.dists.tf = PDB.1hai.h2o.prot.dists.tf)
  }

}
\seealso{
Other "Hydrophilicity Evaluation" "Bound Water Environment": \code{\link{HydrophilicityEvaluation}},
  \code{\link{calcAtomClassHydrophilicity}},
  \code{\link{calcAtomHydrationEstimate}},
  \code{\link{getResidueData}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
