% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterWaters.R
\name{ClusterWaters}
\alias{ClusterWaters}
\title{Cluster Conserved Waters}
\usage{
ClusterWaters(data, cutoff.cluster, cluster.method = "complete")
}
\arguments{
\item{data}{The water oxygens' X, Y, and Z coordinates, B-values, and
occupancy values.}

\item{cutoff.cluster}{Numerical value provided by the user for the distance
between water oxygen atoms to form a cluster; default: 2.4 Angstroms.}

\item{cluster.method}{Method of clustering the waters; default is
"\code{complete}". Any other method accepted by the \code{hclust} function is
appropriate. The original method used by Sanschagrin and Kuhn is the
complete linkage clustering method and is the default. Other options
include "\code{ward.D}" (equivilant to the only Ward option in \code{R} versions
3.0.3 and earlier), "\code{ward.D2}" (implements Ward's 1963 criteria; see
Murtagh and Legendre 2014), "\code{single}" (related to the minimal spanning
tree method and adopts a "friend of friends" clustering method), along with
"\code{average}" (= UPGMA), "\code{mcquitty}" (= WPGMA), "\code{median}" (= WPGMC) or
"\code{centroid}" (= UPGMC). Due to size limitations with \code{\link[stats:hclust]{stats::hclust()}} --
specifically the "\code{size cannot be NA nor exceed 65536}" --
\code{\link[fastcluster:hclust]{fastcluster::hclust()}} is being used because it is a complete replacement
of \code{\link[stats:hclust]{stats::hclust()}}, is fast (compared to \code{\link[stats:hclust]{stats::hclust()}}), and is able
to accommodate dissimilarity matrices with more than 2^16 (65,536)
observations.}
}
\value{
This function returns:
\itemize{
\item \strong{h2o.clusters.raw}: Initial waters with assigned cluster ID
\item \strong{h2o.clusters.summary}: Each cluster's:
\itemize{
\item cluster ID
\item number of waters
\item percent conservation
\item X, Y, and Z cooridinates
\item bound water environment measurements
\item mean distance between waters comprising the cluster
\item mean distance between waters comprising the cluster and the cluster's
centroid
}
\item \strong{h2o.occurrence}: A table indicating the structures (PDBs) contributing
to each cluster. This summary table includes the PDB structure's:
\itemize{
\item resolution
\item R-free value
\item occupancy (mean and standard deviation)
\item mobility (mean and standard deviation)
\item B-value (mean and standard deviation)
\item number of waters in each cluster
\item number of waters passing the mobility cutoff
\item number of waters passing the normalized B-value
\item number of waters passing both cutoff values
\item percentage of waters passing both cutoffs
\item number of clusters the structure contributes to
\item True/False table indicating if the protein structure contributed to
the water cluster
}
\item \strong{clustering.info}: size and timing information
}
}
\description{
Cluster the conserved waters.
}
\details{
Calculate the conserved waters using a collection of
crystallographic protein structures.
}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064. \cr
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002} \cr
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092} \cr
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage} \cr

Fionn Murtagh and Pierre Legendre. Ward's Hierarchical Agglomerative
Clustering Method: Which Algorithms Implement Ward's Criterion?
\emph{Journal of Classification}, 2014, \strong{31}, (\emph{3}), pp
274-295. \cr
\href{http://doi.org/10.1007/s00357-014-9161-z}{DOI: 10.1007/s00357-014-9161-z}

Daniel Müllner. fastcluster: Fast Hierarchical, Agglomerative Clustering
Routines for R and Python. \emph{Journal of Statistical Software}, 2013, \strong{53}
(\emph{9}) \cr
\href{http://dx.doi.org/10.18637/jss.v053.i09}{DOI: 10.18637/jss.v053.i09}
\href{http://danifold.net/fastcluster.html}{fastcluster webpage}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
