% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step1_YieldCurveGeneration.R
\name{buildCurve}
\alias{buildCurve}
\title{Bootstrap discount factors from a yield curve.}
\usage{
buildCurve(
  swapRates,
  tenors,
  fixFreq,
  fixDCC,
  fltFreq,
  fltDCC,
  calendar,
  bdc,
  curveDate,
  numSetDay,
  yieldCurveDCC
)
}
\arguments{
\item{swapRates}{A vector of doubles of swap rates.}

\item{tenors}{A vector of integers of corresponding tenors.}

\item{fixFreq}{An integer of fixed leg frequency of payment in months.}

\item{fixDCC}{A string of fixed leg day count convention from four options:
"Thirty360", "ACT360", "ACT365", or "ACTACT".}

\item{fltFreq}{An integer of floating leg frequency of payment in months.}

\item{fltDCC}{A string of floating leg day count convention from four options:
"Thirty360", "ACT360", "ACT365", or "ACTACT".}

\item{calendar}{A string of the desired calendar convention.}

\item{bdc}{A string of business day convention from two options:
"General" or "NY".}

\item{curveDate}{A string in the format of "YYYY-MM-DD" of yield curve date.}

\item{numSetDay}{An integer of settlement days from yield curve date.}

\item{yieldCurveDCC}{A string of yield curve day count convention from four options:
"Thirty360", "ACT360", "ACT365", or "ACTACT".}
}
\value{
Outputs a data frame of strings of discount dates and doubles of
  discount factors.
}
\description{
Bootstrap discount factors from a yield curve.
}
\examples{
rate <- c(0.69, 0.77, 0.88, 1.01, 1.14, 1.38, 1.66, 2.15) * 0.01
tenor <- c(1, 2, 3, 4, 5, 7, 10, 30)
fixFreq <- 6
fixDCC <- "Thirty360"
fltFreq <- 6
fltDCC <- "ACT360"
calendar <- "NY"
bdc <- "Modified_Foll"
curveDate <- "2016-02-08"
numSetDay <- 2
yieldCurveDCC <- "Thirty360"
buildCurve(rate, tenor, fixFreq, fixDCC, fltFreq, fltDCC, calendar, bdc,
           curveDate, numSetDay, yieldCurveDCC)
}
