% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confrontation.R
\name{aggregate,validation-method}
\alias{aggregate,validation-method}
\title{Aggregate validation results}
\usage{
\S4method{aggregate}{validation}(x, by = c("rule", "record"), drop = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{\link{validation}}}

\item{by}{Report on violations per rule (default) or per record?}

\item{drop}{drop list attribute if the result is list of length 1}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
By default, a \code{data.frame} with the following columns.
\tabular{ll}{
  keys \tab If confront was called with \code{key=}\cr
  \code{npass} \tab Number of items passed\cr
  \code{nfail} \tab Number of items failing\cr
  \code{nNA} \tab Number of items resulting in \code{NA}\cr
  \code{rel.pass} \tab Relative number of items passed\cr
  \code{rel.fail} \tab Relative number of items failing\cr
  \code{rel.NA} \tab Relative number of items resulting in \code{NA}
}
If \code{by='rule'} the relative numbers are computed with respect to the number 
of records for which the rule was evaluated. If \code{by='record'} the relative numbers
are computed with respect to the number of rules the record was tested agains. 

When \code{by='record'} and not all validation results have the same dimension structure,
a list of \code{data.frames} is returned.
}
\description{
Aggregate results of a validation.
}
\examples{

data(retailers)
retailers$id <- paste0("ret",1:nrow(retailers))
v <- validator(
    staff.costs/staff < 25
  , turnover + other.rev==total.rev)

cf <- confront(retailers,v,key="id")
a <- aggregate(cf,by='record')
head(a)

# or, get a sorted result:
s <- sort(cf, by='record')
head(s)


}
\seealso{
Other validation-methods: 
\code{\link{all,validation-method}},
\code{\link{any,validation-method}},
\code{\link{barplot,validation-method}},
\code{\link{check_that}()},
\code{\link{compare}()},
\code{\link{confront}()},
\code{\link{event}()},
\code{\link{plot,validation-method}},
\code{\link{sort,validation-method}},
\code{\link{summary}()},
\code{\link{validation-class}},
\code{\link{values}()}
}
\concept{validation-methods}
