% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{syntax}
\alias{any_duplicated}
\alias{any_missing}
\alias{col_missing}
\alias{fraction_missing}
\alias{number_missing}
\alias{number_unique}
\alias{row_missing}
\alias{syntax}
\title{Syntax to define validation or indicator rules}
\usage{
number_missing(...)

fraction_missing(...)

row_missing(...)

col_missing(...)

number_unique(...)

any_missing(...)

any_duplicated(...)
}
\arguments{
\item{...}{comma-separated list of variable names (not character). If no
variables are specified, the number of missings over all data is counted.}
}
\value{
For \code{number_missing}, the total number of missings over all specified variables.

For \code{fraction_missing}, the fraction of missings over all specified variables

For \code{row_missing} a vector with the number of missings per (sub)record defined by \code{...}.

For \code{col_missing} a vector with the number of missings per column 
   defined by \code{...}.

For \code{number_unique} the number of records, unique for 
  the columns specified in \code{...}.

For \code{any_missing}, \code{TRUE} if any \code{NA} occur in the columns
  specified in \code{...}.

For \code{any_duplicated}, \code{TRUE} if any (sub)records specified by
 \code{...} are duplicated, \code{FALSE} otherwise. Note that \code{NA} is matched with \code{NA}.
}
\description{
The functions mentioned in this help file should only be used in the
context of defining a \code{\link{validator}} or \code{\link{indicator}} object.
}
\section{Note}{

This document only provides a short reference. Please refer to the vignette for worked
examples.

vignette("intro",package="validate")
}

\section{Local, transient assignment}{

The operator `\code{:=}' can be used to set up local variables (during, for example, validation) to save
time (the rhs of an assignment is computed only once) or to make your validation code more maintainable. 
Assignments work more or less like common R assignments: they are only valid for statements coming after 
the assignment and they may be overwritten. The result of computing the rhs is not part of a 
\code{\link{confront}}ation with data.
}

\section{Groups}{

Often the same constraints/rules are valid for groups of variables. 
\code{validate} allows for compact notation. Variable groups can be used in-statement
or by defining them with the \code{:=} operator.

\code{validator( var_group(a,b) > 0 )}

is equivalent to

\code{validator(G := var_group(a,b), G > 0)}

is equivalent to

\code{validator(a>0,b>0)}.

Using two groups results in the cartesian product of checks. So the statement

\code{validator( f=var_group(c,d), g=var_group(a,b), g > f)}

is equivalent to

\code{validator(a > c, b > c, a > d, b > d)}
}

\section{File parsing}{

Please see the vignette on how to read rules from and write rules to file:

\code{vignette("rule-files",package="validate")}
}

