% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uwot.R
\name{simplicial_set_intersect}
\alias{simplicial_set_intersect}
\title{Merge Similarity Graph by Simplicial Set Intersection}
\usage{
simplicial_set_intersect(x, y, weight = 0.5, n_threads = NULL, verbose = FALSE)
}
\arguments{
\item{x}{A sparse matrix representing the first similarity graph in the
intersection operation.}

\item{y}{A sparse matrix representing the second similarity graph in the
intersection operation.}

\item{weight}{A value between \code{0 - 1}, controlling the relative
influence of \code{x} and \code{y} in the intersection. Default
(\code{0.5}) gives equal influence. Values smaller than \code{0.5} put more
weight on \code{x}. Values greater than \code{0.5} put more weight on
\code{y}.}

\item{n_threads}{Number of threads to use when resetting the local metric.
Default is half the number of concurrent threads supported by the system.}

\item{verbose}{If \code{TRUE}, log progress to the console.}
}
\value{
A sparse matrix containing the intersection of \code{x} and
  \code{y}.
}
\description{
Combine two similarity graphs by treating them as fuzzy topological sets and
forming the intersection.
}
\examples{

# Form two different "views" of the same data
iris30 <- iris[c(1:10, 51:60, 101:110), ]
iris_sg12 <- similarity_graph(iris30[, 1:2], n_neighbors = 5)
iris_sg34 <- similarity_graph(iris30[, 3:4], n_neighbors = 5)

# Combine the two representations into one
iris_combined <- simplicial_set_intersect(iris_sg12, iris_sg34)

# Optimize the layout based on the combined view
iris_combined_umap <- optimize_graph_layout(iris_combined, n_epochs = 100)
}
