% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HigherOrderRiskPreferences.R
\name{evaluate_cross_validation}
\alias{evaluate_cross_validation}
\title{Evaluates the cross validation function.}
\usage{
evaluate_cross_validation(
  xi,
  yi,
  lambda = 1,
  n_penalty_dimensions = 1,
  penalty_order = 4,
  ndx = 20,
  deg = 6,
  cross_validation_mode = 0
)
}
\arguments{
\item{xi}{a vector containing the certainty equivalents (x-values of utility points) for a given participant in each use case.}

\item{yi}{can be a vector or a matrix representing the corresponding utility values (y-values of utility points).}

\item{lambda}{lambda is the penalization weight used to compute the initial estimate. The default value is 1.}

\item{n_penalty_dimensions}{number of dimensions (i.e., derivatives) to penalize. Possible values are 1 or 2. The default value is 1.}

\item{penalty_order}{highest dimension (i.e., derivative) to penalize. Must be lower than deg.}

\item{ndx}{number of intervals to partition the distance between the lowest and highest x-values of the utility points.}

\item{deg}{degree of the B-spline basis. Determines the degree of the function to be estimated. If deg = 2, the estimated utility function will consist of quadratic functions.}

\item{cross_validation_mode}{determines which cross validation mode should be used. If 0, then the cross validation method is leave-one-third-out. If 1, then the cross validation method is a theoretical leave-one-out, i.e., based on a formula. The default value is 1.}
}
\value{
Returns, for the given utility points and (possibly default) settings, the predictive quality of the estimated utility function according to cross validation as a function of a specified penalty weight lambda.
}
\description{
Evaluates the cross validation function.
}
\examples{
x <- c(0.0000000, 0.2819824, 0.3007812, 0.4375000, 0.5231934, 0.7784882, 0.8945312, 1.0000000)
y <- c(0.0000, 0.1250, 0.2500, 0.5000, 0.6250, 0.6875, 0.7500, 1.0000)
evaluate_cross_validation(x, y, .5)
}
