% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_linksMetrics.R
\name{bitly_LinksMetricsReferringDomains}
\alias{bitly_LinksMetricsReferringDomains}
\title{Returns metrics about the domains referring click traffic to a link.}
\usage{
bitly_LinksMetricsReferringDomains(link, limit = 1000, unit = c("minute",
  "hour", "day", "week", "month"), units = -1, showRequestURL = FALSE)
}
\arguments{
\item{link}{- a Bitlink.}

\item{limit}{- 1 to 1000 (default=1000).}

\item{unit}{- minute, hour, day, week or month, default: day; Note: when unit is minute the 
maximum value for units is 60.}

\item{units}{- an integer representing the time units to query data for. Pass -1 to return all 
units of time.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug 
purposes.}
}
\value{
clicks - the number of clicks referred from this domain.

domain - the domain referring clicks.

url - the complete URL of the domain referring clicks.
}
\description{
Returns metrics about the domains referring click traffic to a single Bitlink.
}
\examples{
\dontrun{
bitly_token <- bitly_auth(key = "", secret = "")
bitly_LinksMetricsReferringDomains("http://bit.ly/DPetrov", unit = "day", units=-1, limit = 100)
}

}
\seealso{
\url{http://dev.bitly.com/link_metrics.html#v3_link_referring_domains}
}

