% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rflexdog.R
\name{rgeno}
\alias{rgeno}
\title{Simulate individual genotypes from one of the supported \code{\link{flexdog}} models.}
\usage{
rgeno(
  n,
  ploidy,
  model = c("hw", "bb", "norm", "ash", "f1", "s1", "f1pp", "s1pp", "flex", "uniform"),
  allele_freq = NULL,
  od = NULL,
  p1geno = NULL,
  p2geno = NULL,
  mode = NULL,
  pivec = NULL,
  mu = NULL,
  sigma = NULL,
  p1_pair_weights = NULL,
  p2_pair_weights = NULL
)
}
\arguments{
\item{n}{The number of observations.}

\item{ploidy}{The ploidy of the species.}

\item{model}{What form should the prior take? See Details in \code{\link{flexdog}}.}

\item{allele_freq}{If \code{model = "hw"}, then this is the allele frequency of the population.
For any other model, this should be \code{NULL}.}

\item{od}{If \code{model = "bb"}, then this is the overdispersion parameter of the beta-binomial
distribution. See \code{\link{betabinom}} for details. For any other model, this should be
\code{NULL}.}

\item{p1geno}{Either the first parent's genotype if \code{model = "f1"}
(or \code{model = "f1pp"}), or the only parent's
genotype if \code{model = "s1"} (or \code{model = "s1pp"}).
For any other model, this should be \code{NULL}.}

\item{p2geno}{The second parent's genotype if \code{model = "f1"}
(or \code{model = "f1pp"}).
For any other model, this should be \code{NULL}.}

\item{mode}{If \code{model = "ash"}, this is the center of the distribution. This should be a non-integer value
(so the mode is either the floor or the ceiling of \code{mode}).
For any other model, this should be \code{NULL}.}

\item{pivec}{A vector of probabilities. If \code{model = "ash"}, then this represents
the mixing proportions of the discrete uniforms. If
\code{model = "flex"}, then element \code{i} is the probability of genotype \code{i - 1}.
For any other model, this should be \code{NULL}.}

\item{mu}{If \code{model = "norm"}, this is the mean of the normal.
For any other model, this should be \code{NULL}.}

\item{sigma}{If \code{model = "norm"}, this is the standard deviation of the normal.
For any other model, this should be \code{NULL}.}

\item{p1_pair_weights}{The mixing weights for the bivalent
pairs output in \code{\link{get_bivalent_probs}}
at the \code{lvec} level of \code{p1geno}.
If \code{model = "f1pp"} then this is for the first parent.
If \code{model = "s1pp"}, then this is for the only parent.
This should be \code{NULL} for all other values of \code{model}.}

\item{p2_pair_weights}{If \code{model = "s1pp"},
these are the mixing weights for the bivalent
pairs output in \code{\link{get_bivalent_probs}} at the
\code{lvec} level of \code{p2geno} for the second
parent.
This should be \code{NULL} for all other values of \code{model}.}
}
\value{
A vector of length \code{n} with the genotypes of the sampled individuals.
}
\description{
This will simulate genotypes of a sample of individuals drawn from one of the populations supported by
\code{\link{flexdog}}. See the details of \code{\link{flexdog}} for the models allowed. These genotype
distributions are described in detail in Gerard and Ferrão (2019).
}
\details{
The allowable variable values of \code{allele_freq}, \code{od}, \code{p1geno}, \code{p2geno}, \code{pivec},
and \code{mode} varies based on the value of \code{model}. If \code{model = "ash"}, then only
\code{mode} and \code{pivec} can be non-\code{NULL}. If \code{model = "flex"} then only
\code{pivec} can be non-\code{NULL}. If \code{model = "hw"}, then only \code{allele_freq} can
be non-\code{NULL}. If \code{model = "f1"} then only \code{p1geno} and \code{p2geno} can be non-\code{NULL}.
If \code{model = "s1"} then only \code{p1geno} can be non-\code{NULL}. If \code{model = "uniform"}, then
none of the above variables can be non-\code{NULL}. If \code{model = "bb"}, then only \code{allele_freq},
and \code{od} can be non-\code{NULL}. If \code{model == "norm"}, then only \code{mu} and \code{sigma}
can be non-\code{NULL}.
}
\examples{
## F1 Population where parent 1 has 1 copy of the referenc allele
## and parent 2 has 4 copies of the reference allele.
ploidy <- 6
rgeno(n = 10, ploidy = ploidy, model = "f1", p1geno = 1, p2geno = 4)

## A population in Hardy-Weinberge equilibrium with an
## allele frequency of 0.75
rgeno(n = 10, ploidy = ploidy, model = "hw", allele_freq = 0.75)

}
\references{
\itemize{
  \item{Gerard, D., Ferrão, L. F. V., Garcia, A. A. F., & Stephens, M. (2018). Genotyping Polyploids from Messy Sequencing Data. \emph{Genetics}, 210(3), 789-807. doi: \href{https://doi.org/10.1534/genetics.118.301468}{10.1534/genetics.118.301468}.}
  \item{Gerard, D. and Ferrão, L. F. V. (2019). Priors for Genotyping Polyploids. \emph{Bioinformatics}. doi: \href{https://doi.org/10.1093/bioinformatics/btz852}{10.1093/bioinformatics/btz852}.}
}
}
\author{
David Gerard
}
