% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr-ugompertz.R
\name{ugompertz}
\alias{ugompertz}
\alias{dugompertz}
\alias{pugompertz}
\alias{qugompertz}
\alias{rugompertz}
\title{The unit-Gompertz distribution}
\usage{
dugompertz(x, mu, theta, tau = 0.5, log = FALSE)

pugompertz(q, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

qugompertz(p, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

rugompertz(n, mu, theta, tau = 0.5)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{mu}{location parameter indicating the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.}

\item{theta}{nonnegative shape parameter.}

\item{tau}{the parameter to specify which quantile is to be used.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq{x})} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dugompertz} gives the density, \code{pugompertz} gives the distribution function,
\code{qugompertz} gives the quantile function and \code{rugompertz} generates random deviates.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function and random number deviates
for the unit-Gompertz distribution reparametrized in terms of the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.
}
\details{
Probability density function
\deqn{f(y\mid \alpha ,\theta )=\frac{\alpha \theta }{x}\exp \left\{ \alpha -\theta \log \left( y\right) -\alpha \exp \left[ -\theta \log \left( y\right) \right] \right\} }

Cumulative density function
\deqn{F(y\mid \alpha ,\theta )=\exp \left[ \alpha \left( 1-y^{\theta }\right) \right] }

Quantile Function
\deqn{Q(\tau \mid \alpha ,\theta )=\left[ \frac{\alpha -\log \left( \tau \right) }{\alpha }\right] ^{-\frac{1}{\theta }} }

Reparameterization
\deqn{\alpha =g^{-1}(\mu )=\frac{\log \left( \tau \right) }{1-\mu ^{\theta }}}
}
\examples{
set.seed(123)
x <- rugompertz(n = 1000, mu = 0.5, theta = 2, tau = 0.5)
R <- range(x)
S <- seq(from = R[1], to = R[2], by =  0.01)
hist(x, prob = TRUE, main = 'unit-Gompertz')
lines(S, dugompertz(x = S, mu = 0.5, theta = 2, tau = 0.5), col = 2)
plot(ecdf(x))
lines(S, pugompertz(q = S, mu = 0.5, theta = 2, tau = 0.5), col = 2)
plot(quantile(x, probs = S), type = "l")
lines(qugompertz(p = S, mu = 0.5, theta = 2, tau = 0.5), col = 2)
}
\references{
Mazucheli, J., Menezes, A. F. and Dey, S., (2019). Unit-Gompertz Distribution with Applications. \emph{Statistica}, \bold{79}(1), 25-43.
}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

André F. B. Menezes \email{andrefelipemaringa@gmail.com}
}
