% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_color_unhcr_c}
\alias{scale_color_unhcr_c}
\alias{scale_color_unhcr_d}
\alias{scale_color_unhcr_b}
\alias{scale_colour_unhcr_c}
\alias{scale_colour_unhcr_d}
\alias{scale_colour_unhcr_b}
\alias{scale_fill_unhcr_c}
\alias{scale_fill_unhcr_d}
\alias{scale_fill_unhcr_b}
\title{UNHCR ggplot2 color scales}
\usage{
scale_color_unhcr_c(
  ...,
  type = "sequential",
  palette = 1,
  direction = 1,
  na.value = "#E5E5E5",
  guide = "colourbar"
)

scale_color_unhcr_d(
  ...,
  type = "qualitative",
  palette = 1,
  direction = 1,
  nmax = NULL,
  order = NULL,
  na.value = "#E5E5E5"
)

scale_color_unhcr_b(
  ...,
  type = "qualitative",
  palette = 1,
  direction = 1,
  nmax = NULL,
  order = NULL,
  na.value = "#E5E5E5",
  guide = "coloursteps"
)

scale_colour_unhcr_c(
  ...,
  type = "sequential",
  palette = 1,
  direction = 1,
  na.value = "#E5E5E5",
  guide = "colourbar"
)

scale_colour_unhcr_d(
  ...,
  type = "qualitative",
  palette = 1,
  direction = 1,
  nmax = NULL,
  order = NULL,
  na.value = "#E5E5E5"
)

scale_colour_unhcr_b(
  ...,
  type = "qualitative",
  palette = 1,
  direction = 1,
  nmax = NULL,
  order = NULL,
  na.value = "#E5E5E5",
  guide = "coloursteps"
)

scale_fill_unhcr_c(
  ...,
  type = "sequential",
  palette = 1,
  direction = 1,
  na.value = "#E5E5E5",
  guide = "colourbar"
)

scale_fill_unhcr_d(
  ...,
  type = "qualitative",
  palette = 1,
  direction = 1,
  nmax = NULL,
  order = NULL,
  na.value = "#E5E5E5"
)

scale_fill_unhcr_b(
  ...,
  type = "qualitative",
  palette = 1,
  direction = 1,
  nmax = NULL,
  order = NULL,
  na.value = "#E5E5E5",
  guide = "coloursteps"
)
}
\arguments{
\item{...}{Other arguments passed on to
\code{\link[ggplot2:discrete_scale]{discrete_scale}} or
\code{\link[ggplot2:continuous_scale]{continuous_scale}}
to control name, limits, breaks, labels and so forth}

\item{type}{One of \"sequential\", \"diverging\" or \"qualitative\"}

\item{palette}{If a string, will use that named palette. If a number, will
index into the list of palettes of appropriate \code{type}}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are as output by \code{\link[=unhcr_pal]{unhcr_pal()}}. If -1, the order of colors is reversed}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{nmax}{Maximum number of different colors the palette should contain.
If not provided, is calculated automatically from the data.}

\item{order}{Numeric vector listing the order in which the colors
should be used. Default is \code{1:nmax}.}
}
\value{
A discrete, continuous or binned \code{Scale} object
}
\description{
UNHCR ggplot2 color scales
}
\examples{
library(ggplot2)

data(msleep, package = "ggplot2")

ggplot(msleep, aes(vore, sleep_total, fill = vore)) +
  geom_boxplot() +
  scale_fill_unhcr_d(palette = 1, direction = -1)

}
\seealso{
\code{\link[scales:gradient_n_pal]{gradient_n_pal}}
}
