% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umxModelNames}
\alias{umxModelNames}
\title{Return names of models found within a model}
\usage{
umxModelNames(model, includeOuterModelName = FALSE)
}
\arguments{
\item{model}{an \code{\link[=mxModel]{mxModel()}} to search for model names.}

\item{includeOuterModelName}{FALSE}
}
\value{
\itemize{
\item All models names
}
}
\description{
\code{umxModelNames} returns the names of each model contained in the model provided to it
(optionally excluding the out model itself).
}
\examples{
\dontrun{
data(GFF)
mzData = subset(GFF, zyg_2grp == "MZ")
dzData = subset(GFF, zyg_2grp == "DZ")
selDVs = c("gff", "fc", "qol")
m1 = umxCP(selDVs= selDVs, nFac= 1, dzData= dzData, mzData= mzData, sep= "_T", autoRun= TRUE)
m2 = mxRename(m1, "model2")
umxModelNames(m1) # "top" "MZ" "DZ"
umxModelNames(m2) # "top" "MZ" "DZ"

super = umxSuperModel("myModel", m1, m2, autoRun = TRUE)
umxModelNames(super)

plot(super$CP1fac)
}
}
\seealso{
\itemize{
\item \code{\link[=mxRename]{mxRename()}}, \code{\link[=umxSuperModel]{umxSuperModel()}}
}

Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{libs}()},
\code{\link{qm}()},
\code{\link{umxLav2RAM}()},
\code{\link{umxRAM2Lav}()},
\code{\link{umxVersion}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_lower.tri}()},
\code{\link{umx_msg}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_pad}()},
\code{\link{umx_print}()},
\code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
