% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavanify2ram.R
\name{umxRAM2Lav}
\alias{umxRAM2Lav}
\title{Convert a RAM model to a lavaan string}
\usage{
umxRAM2Lav(model)
}
\arguments{
\item{model}{an OpenMx RAM model}
}
\value{
A lavaan syntax string, e.g. "A~~B"
}
\description{
Takes an OpenMx RAM model and creates the corresponding lavaan syntax string.

This function is at the alpha quality stage, and **should be expected to have bugs**.
Also likely to change functionality and even parameters as new features are supported (e.g. groups)
and lavaan-style strings exported. Several features are not yet supported. Let me know if you would like them.
}
\examples{
\dontrun{
umxRAM2Lav(umxLav2RAM("x ~ y", autoRun = FALSE, printTab = FALSE, lavaanMode = "lavaan"))
}
}
\seealso{
- [umxLav2RAM()], [umxRAM()]

Other Miscellaneous Utility Functions: 
\code{\link{install.OpenMx}()},
\code{\link{libs}()},
\code{\link{qm}()},
\code{\link{umxLav2RAM}()},
\code{\link{umxModelNames}()},
\code{\link{umxVersion}()},
\code{\link{umx_array_shift}()},
\code{\link{umx_find_object}()},
\code{\link{umx_lower.tri}()},
\code{\link{umx_msg}()},
\code{\link{umx_open_CRAN_page}()},
\code{\link{umx_pad}()},
\code{\link{umx_print}()},
\code{\link{umx}}
}
\concept{Miscellaneous Utility Functions}
