% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_make_sql_from_excel}
\alias{umx_make_sql_from_excel}
\title{Convert an excel spreadsheet in a text file on sql statements.}
\usage{
umx_make_sql_from_excel(theFile = "Finder")
}
\arguments{
\item{theFile}{The xlsx file to read. Default = "Finder")}
}
\value{
None
}
\description{
Unlikely to be of use to anyone but the package author :-)
}
\details{
On OS X, by default, the file selected in the front-most Finder window will be chosen.
If it is blank, a choose file dialog will be thrown.

Read an xlsx file and convert into SQL insert statements (placed on the clipboard)
On MacOS, the function can access the current front-most Finder window.

The file name should be the name of the test.
Columns should be headed:
itemText	direction	scale	type	[optional	response	options]

The SQL fields generated are:
itemID, test, native_item_number, item_text, direction, scale, format, author

tabbedPlus: list scored from 0 to n-1

tabbedVertPlus: tabbed, but vertical lay-out

number	2+2\<itemBreak\>min='0' max='7' step='1'

5fm Scored 1-5, anchored: Strongly Disagree | Disagree  | Neutral | Agree | Strongly Agree

intro (not) scored, and sequenced as item 0
}
\examples{
\dontrun{
# An example Excel spreadsheet
# local uncompiled path
fp = system.file("inst/extdata", "GQ6.sql.xlsx", package = "umx")
# installed path
fp = system.file("extdata", "GQ6.sql.xlsx", package = "umx")
umx_open(fp)
umx_make_sql_from_excel() # Using file selected in front-most Finder window
umx_make_sql_from_excel("~/Desktop/test.xlsx") # provide a path
}
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
Other File Functions: 
\code{\link{dl_from_dropbox}()},
\code{\link{umx_file_load_pseudo}()},
\code{\link{umx_move_file}()},
\code{\link{umx_open}()},
\code{\link{umx_rename_file}()},
\code{\link{umx_write_to_clipboard}()},
\code{\link{umx}}
}
\concept{File Functions}
