% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxSexLim.R
\name{umxSummarySexLim}
\alias{umxSummarySexLim}
\alias{umxSummary.MxModelSexLim}
\title{Shows a compact, publication-style, summary of a umx Sex Limitation model}
\usage{
umxSummarySexLim(
  model,
  digits = 2,
  file = getOption("umx_auto_plot"),
  comparison = NULL,
  std = TRUE,
  showRg = FALSE,
  CIs = TRUE,
  report = c("markdown", "html"),
  extended = FALSE,
  zero.print = ".",
  show = c("std", "raw"),
  returnStd = FALSE,
  ...
)
}
\arguments{
\item{model}{a \code{\link[=umxSexLim]{umxSexLim()}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: "name" = use the name of the model.
Defaults to NA = do not create plot output}

\item{comparison}{you can run mxCompare on a comparison model (NULL)}

\item{std}{Whether to standardize the output (default = TRUE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{CIs}{Whether to show Confidence intervals if they exist (T)}

\item{report}{If "html", then open an html table of the results}

\item{extended}{how much to report (FALSE)}

\item{zero.print}{How to show zeros (".")}

\item{show}{Here to support being called from generic xmu_safe_run_summary. User should ignore: can be c("std", "raw")}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{...}{Other parameters to control model summary}
}
\value{
\itemize{
\item optional \code{\link[=mxModel]{mxModel()}}
}
}
\description{
Summarize a fitted Cholesky model returned by \code{\link[=umxSexLim]{umxSexLim()}}. Can control digits, report comparison model fits,
optionally show the Rg (genetic and environmental correlations), and show confidence intervals. The report parameter allows
drawing the tables to a web browser where they may readily be copied into non-markdown programs like Word.
}
\details{
See documentation for summary functions for other types of umx model here: \code{\link[=umxSummary]{umxSummary()}}.
}
\examples{
\dontrun{
# ======================================================
# = Beta: Should be good to use for Boulder/March 2020 =
# ======================================================

# =============================================
# = Run Qualitative Sex Differences ACE model =
# =============================================

# =========================
# = Load and Process Data =
# =========================
require(umx)
umx_set_optimizer("SLSQP")
data("us_skinfold_data")
# rescale vars
us_skinfold_data[, c('bic_T1', 'bic_T2')] = us_skinfold_data[, c('bic_T1', 'bic_T2')]/3.4
us_skinfold_data[, c('tri_T1', 'tri_T2')] = us_skinfold_data[, c('tri_T1', 'tri_T2')]/3
us_skinfold_data[, c('caf_T1', 'caf_T2')] = us_skinfold_data[, c('caf_T1', 'caf_T2')]/3
us_skinfold_data[, c('ssc_T1', 'ssc_T2')] = us_skinfold_data[, c('ssc_T1', 'ssc_T2')]/5
us_skinfold_data[, c('sil_T1', 'sil_T2')] = us_skinfold_data[, c('sil_T1', 'sil_T2')]/5

# Variables for Analysis
selDVs = c('ssc','sil','caf','tri','bic')
# Data for each of the 5 twin-type groups
mzmData = subset(us_skinfold_data, zyg == 1)
mzfData = subset(us_skinfold_data, zyg == 2)
dzmData = subset(us_skinfold_data, zyg == 3)
dzfData = subset(us_skinfold_data, zyg == 4)
dzoData = subset(us_skinfold_data, zyg == 5)

# ======================
# = Bivariate example =
# ======================

selDVs = c('tri','bic')
m1 = umxSexLim(selDVs = selDVs, sep = "_T", A_or_C = "A", tryHard = "yes",
	mzmData = mzmData, dzmData = dzmData, 
	mzfData = mzfData, dzfData = dzfData, 
	dzoData = dzoData
)
umxSummary(m1, file = NA);

# ===============
# = Switch to C =
# ===============
m1 = umxSexLim(selDVs = selDVs, sep = "_T", A_or_C = "C", tryHard = "yes",
	mzmData = mzmData, dzmData = dzmData, 
	mzfData = mzfData, dzfData = dzfData, 
	dzoData = dzoData
)
}
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=umxSexLim]{umxSexLim()}}, \code{\link[=umxPlotSexLim]{umxPlotSexLim()}}
}

Other Twin Reporting Functions: \code{\link{umxPlotCP}()},
  \code{\link{umxPlotDoC}()}, \code{\link{umxReduceACE}()},
  \code{\link{umxReduceGxE}()}, \code{\link{umxReduce}()},
  \code{\link{umxSummarizeTwinData}()},
  \code{\link{umxSummaryACEcov}()},
  \code{\link{umxSummaryACEv}()},
  \code{\link{umxSummaryACE}()},
  \code{\link{umxSummaryCP}()},
  \code{\link{umxSummaryDoC}()},
  \code{\link{umxSummaryGxEbiv}()},
  \code{\link{umxSummaryGxE}()},
  \code{\link{umxSummaryIP}()},
  \code{\link{umxSummarySimplex}()}, \code{\link{umx}}
}
\concept{Twin Reporting Functions}
