% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxReduceACE}
\alias{umxReduceACE}
\title{Reduce an ACE model.}
\usage{
umxReduceACE(model, report = c("markdown", "inline", "html", "report"),
  baseFileName = "tmp", intervals = TRUE, ...)
}
\arguments{
\item{model}{an ACE or ADE \code{\link{mxModel}} to reduce}

\item{report}{How to report the results. "html" = open in browser}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp")}

\item{intervals}{Recompute CIs (if any included) on the best model (default = TRUE)}

\item{...}{Other parameters to control model summary}
}
\value{
Best fitting model
}
\description{
This function can perform model reduction on \code{\link{umxACE}} models,
testing dropping A and C, as well as an ADE or ACE model, displaying the results
in a table, and returning the best model.
}
\details{
It is designed for testing univariate models. You can offer up either the ACE or ADE base model.

Suggestions for more sophisticated automation welcomed!
}
\examples{
data(twinData)
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "")
m2 = umxReduce(m1)
umxSummary(m2)
m1 = umxACE(selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "", dzCr = .25)
m2 = umxReduce(m1)
}
\references{
\itemize{
\item Wagenmakers, E.J., & Farrell, S. (2004). AIC model selection using Akaike weights. \emph{Psychonomic Bulletin and Review}, \strong{11}, 192-196. \href{https://doi.org/10.3758/BF03206482}{doi:}
}
}
\seealso{
\code{\link{umxReduceGxE}}, \code{\link{umxReduce}}

Other Twin Reporting Functions: \code{\link{umxReduceGxE}},
  \code{\link{umxReduce}}, \code{\link{umx}}
}
\concept{Twin Reporting Functions}
