% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_get_CI}
\alias{xmu_get_CI}
\title{xmu_get_CI}
\usage{
xmu_get_CI(model, label, prefix = "top.", suffix = "_std",
  digits = 2, SEstyle = FALSE, verbose = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to get CIs from}

\item{label}{the label of the cell to interrogate for a CI, e.g. "ai_r1c1"}

\item{prefix}{The submodel to look in (default = "top.")}

\item{suffix}{The suffix for algebras when standardized (default = "_std")}

\item{digits}{= 2}

\item{SEstyle}{If TRUE, report "b(se)" instead of b CI95[l,u] (default = FALSE)}

\item{verbose}{= FALSE}
}
\value{
- the CI string, e.g. ".73[-.20, .98]" or .73(.10)
}
\description{
Look up CIs for free parameters in a model, and return as APA-formatted text string.
If std are available then they are reported.
}
\examples{
require(umx); data(demoOneFactor)
latents = c("g"); manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
m1 = umxCI(m1, run= "yes")

# Get CI by parameter label
xmu_get_CI(model= m1, "x1_with_x1")
xmu_get_CI(model= m1, "x1_with_x1", SEstyle=TRUE, digits=3)

# prefix (submodel) and suffix (e.g. std) are ignored if not needed
xmu_get_CI(model =m1, "x1_with_x1", prefix = "top.", suffix = "_std")

\dontrun{
xmu_get_CI(fit_IP, label = "ai_r1c1", prefix = "top.", suffix = "_std")
xmu_get_CI(fit_IP, label = "ai_r1c1", prefix = "top.", SEstyle = TRUE, suffix = "_std")
}
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{tmx_show}},
  \code{\link{umxAPA}}, \code{\link{umxEval}},
  \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umxWeightedAIC}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_names}}, \code{\link{umx_parameters}},
  \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_time}}, \code{\link{umx}}
}
\concept{Reporting Functions}
