% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_pad}
\alias{umx_pad}
\title{Pad an Object with NAs}
\usage{
umx_pad(x, n)
}
\arguments{
\item{x}{An \R object (list, data.frame, matrix, atomic vector).}

\item{n}{The final length of each object.}
}
\value{
- padded object
}
\description{
This function pads an R object (list, data.frame, matrix, atomic vector)
with \code{NA}s. For matrices, lists and data.frames, this occurs by extending
each (column) vector in the object.
}
\examples{
umx_pad(1:3, 4)
umx_pad(1:3, 3)
}
\references{
- \url{https://github.com/kevinushey/Kmisc/tree/master/man}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_array_shift}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_read_lower}}, \code{\link{umx_rename}},
  \code{\link{umx_reorder}}, \code{\link{umx_scale}},
  \code{\link{umx_stack}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}
