% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_APA_pval}
\alias{umx_APA_pval}
\title{Round p-values according to APA guidelines}
\usage{
umx_APA_pval(p, min = 0.001, digits = 3, addComparison = NA)
}
\arguments{
\item{p}{The p-value to round}

\item{min}{Values below min will be reported as "< min"}

\item{digits}{Number of decimals to which to round (default = 3)}

\item{addComparison}{Whether to add '=' '<' etc. (NA adds when needed)}
}
\value{
- p-value formatted in APA style
}
\description{
umx_APA_pval formats p-values, rounded correctly. So you get '< .001' instead of .000000002 or 1.00E-09.

You set the precision with digits. Optionally, you can add '=' '<' etc. The default for addComparison (NA) adds these when needed.
}
\examples{
umx_APA_pval(.052347)
umx_APA_pval(1.23E-3)
umx_APA_pval(1.23E-4)
umx_APA_pval(c(1.23E-3, .5))
umx_APA_pval(c(1.23E-3, .5), addComparison = TRUE)
}
\seealso{
- \code{\link{umxAPA}}, \code{\link{round}}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxReduce}},
  \code{\link{umxSummary}}, \code{\link{umx_aggregate}},
  \code{\link{umx_parameters}}, \code{\link{umx_print}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
