% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxReduceACE}
\alias{umxReduceACE}
\title{Reduce an ACE model.}
\usage{
umxReduceACE(model, report = c("markdown", "inline", "html", "report"),
  baseFileName = "tmp", intervals = TRUE, ...)
}
\arguments{
\item{model}{an ACE or ADE \code{\link{mxModel}} to reduce}

\item{report}{How to report the results. "html" = open in browser}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp")}

\item{intervals}{Recompute CIs (if any included) on the best model (default = TRUE)}

\item{...}{Other parameters to control model summary}
}
\value{
Best fitting model
}
\description{
This function can perform model reduction on \code{\link{umxACE}} models,
testing dropping A and C, as well as an ADE or ACE model, displaying the results
in a table, and returning the best model.
}
\details{
It is designed for testing univariate models. You can offer up either the ACE or ADE base model.

Suggestions for more sophisticated automation welcomed!
}
\examples{
data(twinData)
mzData <- subset(twinData, zygosity == "MZFF")
dzData <- subset(twinData, zygosity == "DZFF")
m1 = umxACE(selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "")
m2 = umxReduce(m1)
umxSummary(m2)
m1 = umxACE(selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "", dzCr = .25)
m2 = umxReduce(m1)
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
Other Core Modelling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxDiagnose}}, \code{\link{umxLatent}},
  \code{\link{umxMatrix}}, \code{\link{umxPath}},
  \code{\link{umxRAM}}, \code{\link{umxReduceGxE}},
  \code{\link{umxRun}}, \code{\link{umxSuperModel}},
  \code{\link{umx}}

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}},
  \code{\link{umxACE_cov_fixed}}, \code{\link{umxACEcov}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCF_SexLim}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxE}},
  \code{\link{umxIP}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umx_long2wide}}, \code{\link{umx_wide2long}},
  \code{\link{umx}}, \code{\link{xmu_twin_check}}
}
