% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_scale_wide_twin_data}
\alias{umx_scale_wide_twin_data}
\title{umx_scale_wide_twin_data}
\usage{
umx_scale_wide_twin_data(varsToScale, suffixes, df)
}
\arguments{
\item{varsToScale}{the base names of the variables ("weight" etc)}

\item{suffixes}{the suffix that distinguishes each case (T1, T2 etc.)}

\item{df}{a wide dataframe}
}
\value{
- new dataframe with scaled variables
}
\description{
Scale wide data across all cases: currently twins
}
\examples{
data(twinData)
df = umx_scale_wide_twin_data(twinData, varsToScale = c("ht", "wt"), suffixes = c("1","2") )
plot(wt1 ~ wt2, data = df)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{umxLabel}}, \code{\link{umxRun}}, \code{\link{umxValues}}

Other Miscellaneous Data Functions: \code{\link{umxCovData}};
  \code{\link{umxHetCor}};
  \code{\link{umxPadAndPruneForDefVars}};
  \code{\link{umx_as_numeric}};
  \code{\link{umx_cont_2_ordinal}};
  \code{\link{umx_cov2raw}}; \code{\link{umx_lower2full}};
  \code{\link{umx_make_bin_cont_pair_data}};
  \code{\link{umx_merge_CIs}};
  \code{\link{umx_read_lower}};
  \code{\link{umx_residualize}}; \code{\link{umx_round}};
  \code{\link{umx_scale}}; \code{\link{umx_swap_a_block}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

