% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_cov_diag}
\alias{umx_cov_diag}
\title{umx_cov_diag}
\usage{
umx_cov_diag(df, ordVar = 1, format = c("diag", "Full", "Lower"),
  use = c("complete.obs", "pairwise.complete.obs", "everything", "all.obs",
  "na.or.complete"))
}
\arguments{
\item{df}{a dataframe of raw data from which to get variances.}

\item{ordVar}{The value to return at any ordinal columns (defaults to 1)}

\item{format}{to return: options are c("diag", "Full", "Lower"). Defaults to diag: a vector of variances}

\item{use}{passed to \code{\link{cov}} - defaults to "complete.obs" (other options are in the function )}
}
\value{
- \code{\link{mxModel}}
}
\description{
Helper to get variances from a df that might contain some non-numeric columns.
Values at non-numeric columns are set to the value passed in as ordVar.
}
\examples{
tmp = mtcars[,1:4]
tmp$cyl = ordered(mtcars$cyl) # ordered factor
tmp$hp  = ordered(mtcars$hp)  # binary factor
umx_cov_diag(tmp, ordVar = 1, use = "pair")
tmp2 = tmp[, c(1,3)]
umx_cov_diag(tmp2)
umx_cov_diag(tmp2, format = "Full")
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
Other Miscellaneous Building Functions: \code{\link{umx_check_names}}
}

