% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_paginated_data}
\alias{get_paginated_data}
\title{Get Paginated Data}
\usage{
get_paginated_data(
  theme = NULL,
  sub_theme = NULL,
  topic = NULL,
  geography_type = NULL,
  geography = NULL,
  metric = NULL,
  page_number = 1,
  page_size = 365
)
}
\arguments{
\item{theme}{the largest overall topical subgroup of data. For
example \code{infectious_disease}.}

\item{sub_theme}{a topical subgroup associated with the parent theme.
For example \code{respiratory}.}

\item{topic}{categorical subgroup associated with the selected
theme and sub_theme. For example, \code{COVID-19}.}

\item{geography_type}{the overarching area type for the intended geography.
For example \code{Nation}.}

\item{geography}{the selected area under the \code{geography_type}.
For example \code{England}.}

\item{metric}{the type of data being selected.
For example \code{COVID-19_testing_PCRcountByDay}.}

\item{page_number}{define which page of data to retrieve}

\item{page_size}{define number of results returned per page.
Maximum supported size is 365.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{           list containing the query structure and results
}\if{html}{\out{</div>}}
}
\description{
Generates API query URL and retrieves paginated data.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{          If any input argument is left NULL or invalid, a list of possible values for that parameter is
                   returned.
}\if{html}{\out{</div>}}
}
\examples{
data <- get_paginated_data(
          theme = "infectious_disease",
          sub_theme = "respiratory",
          topic = "COVID-19",
          geography_type = "Nation",
          geography = "England",
          metric = "COVID-19_cases_casesByDay",
          page_number = 2
          )
}
