% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_cooccurrence.R
\name{as.matrix.cooccurrence}
\alias{as.matrix.cooccurrence}
\title{Convert the result of cooccurrence to a sparse matrix}
\usage{
\method{as.matrix}{cooccurrence}(x, ...)
}
\arguments{
\item{x}{an object of class \code{cooccurrence} as returned by  \code{\link{cooccurrence}}}

\item{...}{not used}
}
\value{
a sparse matrix with in the rows and columns the terms and in the cells how many times
the cooccurrence occurred
}
\description{
Convert the result of \code{\link{cooccurrence}} to a sparse matrix.
}
\examples{
data(brussels_reviews_anno)
## By document, which lemma's co-occur
x <- subset(brussels_reviews_anno, xpos \%in\% c("NN", "JJ") & language \%in\% "fr")
x <- cooccurrence(x, group = "doc_id", term = "lemma")
x <- as.matrix(x)
dim(x)
x[1:3, 1:3]
}
\seealso{
\code{\link{cooccurrence}}
}
