% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_flow.R
\name{dtm_sample}
\alias{dtm_sample}
\title{Random samples and permutations from a Document-Term-Matrix}
\usage{
dtm_sample(dtm, size = nrow(dtm), replace = FALSE, prob = NULL)
}
\arguments{
\item{dtm}{a document term matrix of class dgCMatrix (which can be an object returned by \code{\link{document_term_matrix}})}

\item{size}{a positive number, the number of rows to sample}

\item{replace}{should sampling be with replacement}

\item{prob}{a vector of probability weights, one for each row of \code{x}}
}
\value{
\code{dtm} with as many rows as specified in \code{size}
}
\description{
Sample the specified number of rows from the Document-Term-Matrix using either with or without replacement.
}
\examples{
x <- list(doc1 = c("aa", "bb", "cc", "aa", "b"), 
          doc2 = c("bb", "bb", "dd", ""), 
          doc3 = character(),
          doc4 = c("cc", NA), 
          doc5 = character())
dtm <- document_term_matrix(x)
dtm_sample(dtm, size = 2)
dtm_sample(dtm, size = 3)
dtm_sample(dtm, size = 2)
dtm_sample(dtm, size = 8, replace = TRUE)
dtm_sample(dtm, size = 8, replace = TRUE, prob = c(1, 1, 0.01, 0.5, 0.01))
}
