% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_crownfilter.R
\name{crown_filter}
\alias{crown_filter}
\title{basic filtering of crown polygons using altitude, area and other optional thresholds}
\usage{
crown_filter(crownFn, minTreeAlt = 10, minCrownArea = 5,
  maxCrownArea = 100, minTreeAltParam = "chm_Q50", crownSTDW = NULL,
  opt = NULL, TAopt = NULL,
  proj4string = "+proj=utm +zone=32 +ellps=GRS80 +units=m +no_defs")
}
\arguments{
\item{crownFn}{filname of OGR compliant vector file}

\item{minTreeAlt}{minimum height in meter that will be regarded as tree}

\item{minCrownArea}{minimum area of crowns that is accepted}

\item{maxCrownArea}{maximum area of crowns that is accepted}

\item{minTreeAltParam}{parameter that is used for filtering MinTreeAlt, default is Median "chmQ50"}

\item{crownSTDW}{parameter that optionally filters for the STDV of the crown altitudes, default is NULL}

\item{opt}{threshold value for optional filter, default is NULL}

\item{TAopt}{optional parameter that might be used for filtering, default is NULL}

\item{proj4string}{proj4 string}
}
\description{
applies basic filtering of crown polygons using altitude, area and other optional thresholds. crown_filter basically returns SPDF with the crown polygons and all calculated parameters.
}
\examples{
\dontrun{

 require(uavRst)
 require(link2GI)

# project folder
 projRootDir<-tempdir()

# create subfolders please mind that the pathes are exported as global variables
 paths<-link2GI::initProj(projRootDir = projRootDir,
                         projFolders = c("data/","data/ref/","output/","run/","las/"),
                         global = TRUE,
                         path_prefix = "path_")
# overide trailing backslash issue
 setwd(path_run)

# get the data
utils::download.file("https://github.com/gisma/gismaData/raw/master/uavRst/data/crowns.zip",
                       paste0(path_run,"crowns.zip"))
unzip(zipfile = paste0(path_run,"crowns.zip"), exdir =".")

 raster::plot(raster::shapefile(paste0(path_run,"polyStat.shp")))

# start postclassification of segements
tree_crowns <- crown_filter(crownFn =  paste0(path_run,"polyStat.shp"),
                             minTreeAlt = 3,
                             minCrownArea = 20,
                             maxCrownArea = 50,
                             minTreeAltParam = "chmQ20" )
# visualize it
raster::plot(tree_crowns[[2]])
##+}

}
\author{
Chris Reudenbach
}
