% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMARconstructor.R
\name{add_data}
\alias{add_data}
\title{Add data to object of class 'gsmar' defining a GMAR, StMAR, or G-StMAR model}
\usage{
add_data(
  data,
  gsmar,
  calc_qresiduals = TRUE,
  calc_cond_moments = TRUE,
  calc_std_errors = FALSE,
  custom_h = NULL
)
}
\arguments{
\item{data}{a numeric vector or class \code{'ts'} object containing the data. \code{NA} values are not supported.}

\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{calc_qresiduals}{should quantile residuals be calculated? Default is \code{TRUE} iff the model contains data.}

\item{calc_cond_moments}{should conditional means and variances be calculated? Default is \code{TRUE} iff the model contains data.}

\item{calc_std_errors}{should approximate standard errors be calculated?}

\item{custom_h}{A numeric vector with same the length as the parameter vector: i:th element of custom_h is the difference
used in central difference approximation for partial differentials of the log-likelihood function for the i:th parameter.
If \code{NULL} (default), then the difference used for differentiating overly large degrees of freedom parameters
is adjusted to avoid numerical problems, and the difference is \code{6e-6} for the other parameters.}
}
\value{
Returns an object of class 'gsmar' defining the GMAR, StMAR, or G-StMAR model with the data added to the model.
  If the object already contained data, the data will be updated. Does not modify the 'gsmar' object given as argument!
}
\description{
\code{add_data} adds or updates data to object of class '\code{gsmar}' that defines a GMAR, StMAR,
 or G-StMAR model. Also calculates empirical mixing weights, conditional moments, and quantile residuals accordingly.
}
\examples{
# GMAR model without data
params12 <- c(0.18, 0.93, 0.01, 0.86, 0.68, 0.02, 0.88)
gmar12 <- GSMAR(p=1, M=2, params=params12, model="GMAR")
gmar12

# Add data to the model
gmar12 <- add_data(data=logVIX, gmar12)
gmar12
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distribution.	arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{iterate_more}}, \code{\link{get_gradient}},
 \code{\link{get_regime_means}}, \code{\link{swap_parametrization}}, \code{\link{stmar_to_gstmar}}
}
